//------------------------------------------------------------------
#property link          "https://Indicatorszone.com/"
#property description   "Find More on IndicatorsZone.com"
//------------------------------------------------------------------
#property indicator_chart_window
#property strict

//
//
//
//
//

extern string Symbols           = "EURUSD;GBPUSD;USDCHF;USDJPY;EURJPY;GBPJPY;CHFJPY;AUDJPY;NZDJPY;";  // Symbols to use (separetd by ";" in the list)
extern string TimeFrames        = "M1;M5;M15;M30;H1;H4;D1;W1;MN";        // Time frames to use (separated by ";" in the list)
extern int    Tenkan            = 9;                                     // Tenkan period
extern int    Kijun             = 26;                                    // Kijun period
extern int    Senkou            = 52;                                    // Senkou period
extern int    BarToTest         = 0;                                     // Bar to test 
extern color  StrongUp          = clrLimeGreen;                          // Color for strong up
extern color  WeakUp            = clrGreen;                              // Color for weak up
extern color  NoMove            = clrDimGray;                            // Color for no change
extern color  WeakDown          = clrFireBrick;                          // Color for weak down
extern color  StrongDown        = clrRed;                                // Color for strong down
extern color  DoesNotExist      = clrBlack;                              // Color for non existant symbol
extern color  TextColor         = clrBlack;                              // Color for buton text
extern color  BorderColor       = clrBlack;                              // Color for buton border
extern int    Window            = 0;                                     // Window to use for display
extern ENUM_BASE_CORNER  Corner = 2;                                     // Corner for display
extern int    XShift            = 0;                                     // Horizontal shift
extern int    YShift            = 0;                                     // Vertical shift
extern string UniqueID          = "kumo cloud hetmap 1";                 // Indicator unique ID

//
//
//
//
//

int    cpairsLenH;
int    ctimesLen;
string cpairsh[];
int    aTimes[];

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//


//
//
//
//
//

int init()
{
   setUpStrings(cpairsh,cpairsLenH,Symbols);

      TimeFrames = StringTrimLeft(StringTrimRight(TimeFrames)); StringToUpper(TimeFrames);
      if (StringSubstr(TimeFrames,StringLen(TimeFrames)-1,1) != ";")
                       TimeFrames = StringConcatenate(TimeFrames,";");

      //
      //
      //
      //
      //                                   
            
         int s = 0;
         int i = StringFind(TimeFrames,";",s);
         int time;
            while (i > 0)
            {
               string current = StringSubstr(TimeFrames,s,i-s);
               time    = stringToTimeFrame(current);
               if (time > 0) {
                     ArrayResize(aTimes,ArraySize(aTimes)+1);
                                 aTimes[ArraySize(aTimes)-1] = time; }
                                 s = i + 1;
                                     i = StringFind(TimeFrames,";",s);
            }
      ctimesLen = ArraySize(aTimes);
      if (Corner==CORNER_LEFT_LOWER  || Corner==CORNER_RIGHT_LOWER) invertArray(cpairsh); 
      if (Corner==CORNER_RIGHT_UPPER || Corner==CORNER_RIGHT_LOWER) invertiArray(aTimes);

      //
      //
      //
      //
      //
            
   IndicatorShortName(UniqueID);
   return(0);
}

//
//
//
//
//

int deinit()
{
   int idLength = StringLen(UniqueID);
   for (int i = ObjectsTotal(); i>=0; i--)
   {
         string name = ObjectName(i);
         if (StringSubstr(name,0,idLength) == UniqueID) ObjectDelete(name);
   }         
   return(0);
}


//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int start()
{
   int xshift=0, nxshift=0; if (Corner==CORNER_RIGHT_LOWER || Corner==CORNER_RIGHT_UPPER) { xshift=49; nxshift=66; }
      for (int t = 0; t < cpairsLenH; t++ ) ButtonCreate(0,UniqueID+"t"+(string)t,Window,XShift+nxshift+2,YShift+30+t*15,66,14,Corner,cpairsh[t],"Arial",9,TextColor,BorderColor,clrSilver);
      for (int i = 0; i < ctimesLen;  i++ ) ButtonCreate(0,UniqueID+"h"+(string)i,Window,XShift+xshift+i*50+69,YShift+15,49,14,Corner,timeFrameToString(aTimes[i]),"Arial",9,TextColor,BorderColor,clrSilver);
      for (int i = 0; i < cpairsLenH; i++)
      for (int t = 0; t < ctimesLen;  t++)
      {
         string symbol = cpairsh[i];
         double price  = iClose(symbol,aTimes[t],0);
         bool   exist  = true;
         
            if (price == 0) exist = false;
            if (!exist) continue;      
               double spanA = iIchimoku(symbol,aTimes[t],Tenkan,Kijun,Senkou,MODE_SENKOUSPANA,BarToTest);
               double spanB = iIchimoku(symbol,aTimes[t],Tenkan,Kijun,Senkou,MODE_SENKOUSPANB,BarToTest); 
               double close = iClose(symbol,aTimes[t],BarToTest);       
               double high  = MathMax(spanA,spanB);
               double low   = MathMin(spanA,spanB);
         
            //
            //
            //
            //
            //
       
            color  theColor = DoesNotExist;
                  while (true)
                  {
                     if (price > high)                { theColor = StrongUp;   break; }
                     if (price > close)               { theColor = WeakUp;     break; }
                     if (price < high && price > low) { theColor = NoMove;     break; }
                     if (price < low)                 { theColor = StrongDown; break; }
                                                        theColor = WeakDown;   break; 
                  }
            ButtonCreate(0,UniqueID+(string)t+(string)i,Window,XShift+xshift+t*50+69,YShift+30+i*15,49,14,Corner," ","arial",10,theColor,BorderColor,theColor);
      }
      return(0);
}

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

bool ButtonCreate(const long              chart_ID=0,               // chart's ID 
                  const string            name="Button",            // button name 
                  const int               sub_window=0,             // subwindow index 
                  const int               x=0,                      // X coordinate 
                  const int               y=0,                      // Y coordinate 
                  const int               width=50,                 // button width 
                  const int               height=18,                // button height 
                  const ENUM_BASE_CORNER  corner=CORNER_LEFT_UPPER, // chart corner for anchoring 
                  const string            text="Button",            // text 
                  const string            font="Arial",             // font 
                  const int               font_size=10,             // font size 
                  const color             clr=clrBlack,             // text color 
                  const color             clrBorder=clrBlack,       // border color 
                  const color             back_clr=clrGray,         // background color 
                  const color             border_clr=clrNONE,       // border color 
                  const bool              state=true,               // pressed/released 
                  const bool              back=false,               // in the background 
                  const bool              selection=false,          // highlight to move 
                  const bool              hidden=true,              // hidden in the object list 
                  const long              z_order=0)                // priority for mouse click 
{ 
   ObjectCreate(chart_ID,name,OBJ_BUTTON,sub_window,0,0);
      ObjectSetInteger(chart_ID,name,OBJPROP_XDISTANCE,x); 
      ObjectSetInteger(chart_ID,name,OBJPROP_YDISTANCE,y); 
      ObjectSetInteger(chart_ID,name,OBJPROP_XSIZE,width); 
      ObjectSetInteger(chart_ID,name,OBJPROP_YSIZE,height); 
      ObjectSetInteger(chart_ID,name,OBJPROP_CORNER,corner); 
      ObjectSetInteger(chart_ID,name,OBJPROP_FONTSIZE,font_size); 
      ObjectSetInteger(chart_ID,name,OBJPROP_COLOR,clr); 
      ObjectSetInteger(chart_ID,name,OBJPROP_BGCOLOR,back_clr); 
      ObjectSetInteger(chart_ID,name,OBJPROP_BORDER_COLOR,clrBorder); 
      ObjectSetInteger(chart_ID,name,OBJPROP_BORDER_TYPE,BORDER_FLAT); 
      ObjectSetInteger(chart_ID,name,OBJPROP_BACK,back); 
      ObjectSetInteger(chart_ID,name,OBJPROP_STATE,state); 
      ObjectSetInteger(chart_ID,name,OBJPROP_SELECTABLE,selection); 
      ObjectSetInteger(chart_ID,name,OBJPROP_SELECTED,selection); 
      ObjectSetInteger(chart_ID,name,OBJPROP_HIDDEN,hidden); 
      ObjectSetInteger(chart_ID,name,OBJPROP_ZORDER,z_order); 
         ObjectSetString(chart_ID,name,OBJPROP_TEXT,text); 
         ObjectSetString(chart_ID,name,OBJPROP_FONT,font); 
      return(true); 
} 


//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

void clearObjects()
{
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

//
//
//
//
//

int stringToTimeFrame(string tfs)
{
   StringToUpper(tfs);
   for (int i=ArraySize(iTfTable)-1; i>=0; i--)
         if (tfs==sTfTable[i] || tfs==""+(string)iTfTable[i]) return(iTfTable[i]);
                                                              return(_Period);
}
string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

void setUpStrings(string& array[],int& length, string source)
{
   source = StringTrimLeft(StringTrimRight(source)); 
   if (StringSubstr(source,StringLen(source)-1,1) != ";")
                    source = StringConcatenate(source,";");

   //
   //
   //
   //
   //
   
   int  s = 0;
   int  i = StringFind(source,";",s);
   string current;
      while (i > 0)
      {
         current = StringSubstr(source,s,i-s);
         ArrayResize(array,ArraySize(array)+1);
                     array[ArraySize(array)-1] = current;
                     s = i + 1;
                     i = StringFind(source,";",s);
      }
   length = ArraySize(array);
}

void invertArray(string& array[])
{
   string temp[];
   int    size=ArraySize(array);
      ArrayCopy(temp,array);
      for (int i=0; i<size; i++)
      {
         array[i] = temp[size-i-1];
      }
}
void invertiArray(int& array[])
{
   int temp[];
   int    size=ArraySize(array);
      ArrayCopy(temp,array);
      for (int i=0; i<size; i++)
      {
         array[i] = temp[size-i-1];
      }
}